<?php
namespace App\Http\Controllers\Owner\LeadBookingTourPassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\LeadBookingTourPassenger\Application\Update\LeadBookingTourPassengerUpdaterQuery;
use App\Modules\LeadBookingTourPassenger\Application\Update\LeadBookingTourPassengerUpdaterResponse;
use App\Modules\LeadBookingTourPassenger\Infraestructure\LeadBookingTourPassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingTourPassengerUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBookingTourPassenger";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING_TOUR_PASSENGER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, LeadBookingTourPassengerValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_LeadBookingTourPassenger"));

        /** @var LeadBookingTourPassengerUpdaterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingTourPassengerUpdaterQuery(
            $request->input('Id_LeadBookingTourPassenger'),
            $request->input('LeadBookingTourPassenger_Status'),
            $request->input('Id_LeadBookingTour'),
            $request->input('Id_LeadPassenger')
        ));

        $this->history->updateBasic($request->input("Id_LeadBookingTourPassenger"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
