<?php
namespace App\Http\Controllers\Owner\LeadPassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\LeadPassenger\Application\Update\LeadPassengerUpdaterQuery;
use App\Modules\LeadPassenger\Application\Update\LeadPassengerUpdaterResponse;
use App\Modules\LeadPassenger\Infraestructure\LeadPassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadPassengerUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadPassenger";
        $this->history = new HistoryData(HistoryTables::LEAD_PASSENGER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, LeadPassengerValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_LeadPassenger"));

        /** @var LeadPassengerUpdaterResponse $response */
        $response = $this->queryBus->ask(new LeadPassengerUpdaterQuery(
            $request->input('Id_LeadPassenger'),
            $request->input('LeadPassenger_Name'),
            $request->input('LeadPassenger_LastName'),
            $request->input('LeadPassenger_Email'),
            $request->input('LeadPassenger_Phone'),
            $request->input('LeadPassenger_Gender'),
            $request->input('LeadPassenger_DOB'),
            trim($request->input('LeadPassenger_NoDocument')),
            $request->input('LeadPassenger_Restriction'),
            $request->input('LeadPassenger_Extras'),
            $request->input('LeadPassenger_ImgDocument1'),
            $request->input('LeadPassenger_Status'),
            $request->input('LeadPassenger_InfoStatus'),
            $request->input('Id_LeadBooking'),
            $request->input('Id_TypeDocument'),
            $request->input('Id_UserCountry'),
            $request->input('Id_TypeRate'),
        ));

        $this->history->updateBasic($request->input("Id_LeadPassenger"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
