<?php
namespace App\Http\Controllers\Owner\ModuleNotification;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\ModuleNotification\Application\ModuleNotificationIndexer;
use App\Modules\ModuleNotification\Domain\IdModuleNotification;
use App\Modules\ModuleNotification\Infraestructure\MysqlModuleNotificationRepository;

final class Index extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = 'ModuleNotification';
    }

    public function __invoke($Id_PassengerReview)
    {
        $response = (new ModuleNotificationIndexer(new MysqlModuleNotificationRepository))
            ->__invoke(
                new IdModuleNotification($Id_PassengerReview),
            );
        return ResponseBuilder::Response($response);
    }
}
