<?php
namespace App\Http\Controllers\Owner\ReviewDetail;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\ReviewDetail\Application\Find\ReviewDetailFinder;
use App\Modules\ReviewDetail\Infraestructure\MysqlReviewDetailFindRepository;

/** Entidad que representa los detalles de unión de un group passenger
 * con los datos del review */
class ReviewDetailListController
{
    public function __construct()
    {
    }

    public function __invoke($Id_GroupPassenger)
    {
        $response = (new ReviewDetailFinder(new MysqlReviewDetailFindRepository))
                    ->__invoke(new IdGroupPassenger($Id_GroupPassenger));
        return ResponseBuilder::Response($response);
    }
}
