<?php
namespace App\Http\Controllers\Owner\ReviewNotification;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\AdminSession\Application\Index\AdminSessionGetterQuery;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\ReviewNotification\Application\Accept\ReviewNotificationAccepterQuery;
use App\Modules\ReviewNotification\Application\Accept\ReviewNotificationAccepterResponse;
use App\Modules\ReviewNotification\Infraestructure\ReviewNotificationValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ReviewNotificationAcceptController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "ReviewNotification";
        $this->history = new HistoryData(HistoryTables::REVIEW_NOTIFICATION);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, ReviewNotificationValidators::ACCEPT);

        /** @var AdminSessionGetterResponse */
        $admin = $this->queryBus->ask(new AdminSessionGetterQuery($request->header('Token')));

        $this->history->obtainOld($request->input("Id_ReviewNotification"));

        /** @var ReviewNotificationAccepterResponse $response */
        $response = $this->queryBus->ask(new ReviewNotificationAccepterQuery(
            $request->input('Id_ReviewNotification'),
            $request->input('ReviewNotification_Response'),
            $admin->response()[0]->Response_Id_Admin
        ));

        $this->history->updateBasic($request->input("Id_ReviewNotification"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
