<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlUsage\Application\HtlUsageCampFinder;
use App\Modules\HtlUsage\Application\HtlUsageDeleter;
use App\Modules\HtlUsage\Application\HtlUsageFinder;
use App\Modules\HtlUsage\Application\HtlUsageIndexer;
use App\Modules\HtlUsage\Application\HtlUsageInserter;
use App\Modules\HtlUsage\Application\HtlUsageOrderer;
use App\Modules\HtlUsage\Application\HtlUsageUpdater;
use App\Modules\HtlUsage\Domain\HUIdHtlRoom;
use App\Modules\HtlUsage\Domain\HtlUsage;
use App\Modules\HtlUsage\Domain\HtlUsageDateUsage;
use App\Modules\HtlUsage\Domain\HtlUsageLastName;
use App\Modules\HtlUsage\Domain\HtlUsageLock;
use App\Modules\HtlUsage\Domain\HtlUsageName;
use App\Modules\HtlUsage\Domain\HtlUsageNumber;
use App\Modules\HtlUsage\Domain\HtlUsageRemark;
use App\Modules\HtlUsage\Domain\HtlUsageStatus;
use App\Modules\HtlUsage\Domain\IdHtlUsage;
use App\Modules\HtlUsage\Infraestructure\HtlUsageValidators;
use App\Modules\HtlUsage\Infraestructure\MysqlHtlUsageRepository;
use App\Modules\Shared\Infraestructure\LaravelExceptionHandler;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Throwable;

class c_HtlUsage extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct() {
        $this->oDomain = "HtlUsage";
        $this->history = new HistoryData (HistoryTables::htl_usage);
    }

    public function Insert (Request $Request) {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, HtlUsageValidators::insert);
        
        $oResponse = (new HtlUsageInserter(new MysqlHtlUsageRepository))->__invoke(
            new HtlUsage(
                new HtlUsageDateUsage($Request->input('HtlUsage_DateUsage')),
                new HtlUsageStatus($Request->input('HtlUsage_Status')),
                new HtlUsageLock($Request->input('HtlUsage_Lock')),
                new HtlUsageName($Request->input('HtlUsage_Name')),
                new HtlUsageLastName($Request->input('HtlUsage_LastName')),
                new HtlUsageRemark($Request->input('HtlUsage_Remark')),
                new HUIdHtlRoom($Request->input('Id_HtlRoom'))
            )
        );

        $this->history->insert (
            [],
            $Request,
            $oResponse['Response_Data']['Id']
        );
        
        return ResponseBuilder::Response($oResponse);
    }

    public function Update (Request $Request) {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, HtlUsageValidators::update);

        $this->history->obtainOld($Request->input('Id_HtlUsage'));

        $oResponse = (new HtlUsageUpdater(new MysqlHtlUsageRepository))->__invoke(
            new HtlUsage(
                new HtlUsageDateUsage($Request->input('HtlUsage_DateUsage')),
                new HtlUsageStatus($Request->input('HtlUsage_Status')),
                new HtlUsageLock($Request->input('HtlUsage_Lock')),
                new HtlUsageName($Request->input('HtlUsage_Name')),
                new HtlUsageLastName($Request->input('HtlUsage_LastName')),
                new HtlUsageRemark($Request->input('HtlUsage_Remark')),
                new HUIdHtlRoom($Request->input('Id_HtlRoom')),
                new IdHtlUsage($Request->input('Id_HtlUsage')),
            )
        );  

        $this->history->update (
            $Request->input('Id_HtlUsage'),
            $this->history->oldValue,
            [],
            $Request
        );
        return ResponseBuilder::Response($oResponse);
    }

    public function Delete (Request $request, $Id) {

        $this->history->obtainOld($Id);

        $oResponse = (new HtlUsageDeleter(new MysqlHtlUsageRepository))->__invoke(new IdHtlUsage($Id));
                
        $this->history->delete (
            $Id,
            $this->history->oldValue,
            $request
        );
                
        return ResponseBuilder::Response($oResponse);
    }

    public function Index($Id) {
        $oResponse = (new HtlUsageIndexer(new MysqlHtlUsageRepository))->__invoke(new IdHtlUsage($Id));
        return ResponseBuilder::Response($oResponse);
    }

    public function List($Id_HtlRoom, $Action, Request $Request) {
        $query = $Request->input("query") ? $Request->input("query") : '';
        $oResponse = (new HtlUsageFinder(new MysqlHtlUsageRepository))->__invoke(new HUIdHtlRoom($Id_HtlRoom), $Action, $query);
        return ResponseBuilder::Response($oResponse);
    }

    public function CampList($Id_HtlCamp, $Action, Request $Request) {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, HtlUsageValidators::campList);
        
        $oResponse = (new HtlUsageCampFinder(new MysqlHtlUsageRepository))->__invoke(
            $Request->input("DateStart"),
            $Request->input("DateEnd"),
            new IdHtlCamp($Id_HtlCamp),
            $Action
        );
        $oResponse = (new HtlUsageOrderer())->__invoke($Request->input("DateStart"), $Request->input("DateEnd"), $oResponse);
        return ResponseBuilder::Response($oResponse);
    }

}