<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Intervention\Image\ImageManagerStatic as Image;

use App\Http\Controllers\Owner\c_History;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Illuminate\Support\Facades\DB;

class c_Language extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Language";
        $this->history = new HistoryData(HistoryTables::LANGUAGE);
    }

    public function Insert(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Language_Code'         => 'required|string|max:3',
                                'Language_Name'         => 'required|string|max:250',
                                'Language_Content'      => 'required|int',
                                'Language_Status'       => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {

            #region INSERTA DATOS

            $oParam = [
                trim($Request->input("Language_Code")),
                trim($Request->input("Language_Name")),
                $Request->input("Language_Content"),
                $Request->input("Language_Status")
            ];
            $oData = DB::select('call sp_language_insert(?,?,?,?)', $oParam);

            #endregion
            $data = null;
            //
            //  RESPONSE
            //
            if ($oData[0]->Response_Success == 1) {
                $data = [ 'Id' => $oData[0]->Response_Id ];
                #region HISTORY EXEC
                $this->history->insertBasic($Request);
                #endregion
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = $data;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Id_Language'       => 'required|int',
                                'Language_Code'     => 'required|string|max:3',
                                'Language_Name'     => 'required|string|max:250',
                                'Language_Content'  => 'required|int',
                                'Language_Status'   => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            #region HISTORY VARIABLES
            $this->history->obtainOld($Request->input('Id_Language'));
            #endregion

            #region ACTUALIZA DATOS

            $oParam = [
                $Request->input("Id_Language"),
                trim($Request->input("Language_Code")),
                trim($Request->input("Language_Name")),
                $Request->input("Language_Content"),
                $Request->input("Language_Status")
            ];
            $oData = DB::select('call sp_language_update(?,?,?,?,?)', $oParam);

            #endregion

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->updateBasic($Request->input("Id_Language"), $Request);
                #endregion
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Delete(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld($Id);
            #region ELIMINA DATOS
            $oParam = array( $Id );
            $oData  = DB::select('call sp_language_delete(?)', $oParam);

            #endregion

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->deleteBasic($Id, $Request);
                #endregion
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array( $Id );
            $oData  = DB::select('call sp_language_index(?)', $oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    /** Get a list of languages */
    public function List(Request $Request, $Id)
    {
        $oResponse  = array();
        $oResponse = ParamsValidator::Validate_Action($Id, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = array( $Id );
            $oData  = DB::select('call sp_language_list(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list ".$Id;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
        
    public function Selector(Request $Request, $Id)
    {
        if (is_numeric($Id)) {
            return $this->Index($Request, $Id);
        } else {
            return $this->List($Request, $Id);
        }
    }
}
