<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Passenger\Infraestructure\PassengerValidators;
use Illuminate\Support\Facades\DB;
use Intervention\Image\ImageManagerStatic as Image;

class c_Passenger extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Passenger";
        $this->history = new HistoryData(HistoryTables::passenger);
    }

    public static function path1_large()
    {
        return config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_THUMB");
    }

    public static function path1_thumb()
    {
        return config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_LARGE");
    }

    public static function path2_large()
    {
        return config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_THUMB");
    }

    public static function path2_thumb()
    {
        return config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_LARGE");
    }

    public function findBooking($Id_Passenger)
    {
        $passenger = $this->findIndex($Id_Passenger);
        return $passenger ? $passenger->Id_Booking : $passenger;
    }

    public function findIndex($Id_Passenger)
    {
        $found = DB::select('CALL sp_passenger_index(?,?,?,?,?)', [ $Id_Passenger, '', '', '', '' ]);

        if (count($found)) {
            return $found[0];
        } else {
            return null;
        }
    }
        
    public function Insert(Request $Request)
    {
        $oSucces    = true;
        $oResponse  = array();
        $oValParams = array(    'Id_Booking'    => 'required|int',
                                'Date'          => 'string|max:250',
                                'Passenger'     => 'required|string'
                                
                            );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oPassenger = json_decode($Request->input("Passenger"));

            for($k = 0; $k < count($oPassenger); $k++) {
                $oParam             = array(    "",
                                                "",
                                                "",
                                                "",
                                                1,
                                                $Request->input("Date"),
                                                "",
                                                "",
                                                "",
                                                2,
                                                $Request->input("Id_Booking"),
                                                1,
                                                $oPassenger[$k]->Id_TypeRate,
                                                1
                                            );
                $oData              = DB::select('call sp_passenger_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $oParam);

                if ($oData[0]->Response_Success == 0) {
                    $oSucces = false;
                    break;
                }

                //
                // AGREGA INVOICE AL PASAJERO
                //
                $oParam             = array(    $Request->input("Id_Booking"),
                                                $oData[0]->Response_Id,
                                                1
                                            );

                $oData_Invoice      = DB::select('call sp_invoice_insert(?,?,?)', $oParam);

                
                if ($oData_Invoice[0]->Response_Success == 0) {
                    $oSucces    = false;
                    $oData      = $oData_Invoice;
                    break;
                } else {
                    $this->history->insert(
                        [ $this->findIndex($oData[0]->Response_Id) ],
                        $Request,
                        $this->findBooking($oData[0]->Response_Id),
                        false
                    );
                }
            }


            if ($oSucces == true) {
                $oData = array(
                    array(
                        "Response_Status"   => 200,
                        "Response_Code"     => 200,
                        "Response_Message"  => "Pasajeros guardados con éxito",
                        "Response_Reason"   => null
                    )
                );

                $oData = json_decode(json_encode($oData));
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = PassengerValidators::UPDATE;


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld(
                $Request->input('Id_Passenger'),
                self::path1_large(),
                self::path1_thumb(),
                self::path2_large(),
                self::path2_thumb()
            );

            $oParam = array(                $Request->input("Id_Passenger"),
                                 Str::title($Request->input("Passenger_Name")),
                                 Str::title($Request->input("Passenger_LastName")),
                                            $Request->input("Passenger_Status"),
                                            $Request->header("Token"),
                                            1
                            );
            $oData = DB::select('call sp_passenger_notification(?,?,?,?,?,?)', $oParam);


            $oParam = array(                $Request->input("Id_Passenger"),
                                 Str::title($Request->input("Passenger_Name")),
                                 Str::title($Request->input("Passenger_LastName")),
                                            $Request->input("Passenger_Email"),
                                            $Request->input("Passenger_Phone"),
                                            $Request->input("Passenger_Gender"),
                                            $Request->input("Passenger_DOB"),
                            Str::upper(trim($Request->input("Passenger_NoDocument"))),
                                            $Request->input("Passenger_Restriction"),
                                            $Request->input("Passenger_Extras"),
                                            $Request->input("Passenger_Status"),
                                            $Request->input("Id_TypeDocument"),
                                            $Request->input("Id_UserCountry"),
                                            1
                            );
            $oData = DB::select('call sp_passenger_update(?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->update(
                    $this->findBooking($Request->input('Id_Passenger')),
                    $this->history->oldValue,
                    [$Request->all()],
                    $Request
                );
            }else{
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);

    }

    public function UpdateAll(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Id_Passenger'              => 'required|int',
                                'Passenger_Name'            => 'string|max:250',
                                'Passenger_LastName'        => 'string|max:250',
                                'Passenger_Email'           => 'string|max:250',
                                'Passenger_Phone'           => 'string|max:250',
                                'Passenger_Gender'          => 'string|max:250',
                                'Passenger_DOB'             => 'string|max:250',
                                'Passenger_NoDocument'      => 'string|max:250',
                                'Passenger_Restriction'     => 'string',
                                'Passenger_Extras'          => 'string',
                                'Passenger_ImgDocument1'    => 'image|mimes:'.config("var.MIME_IMG"),
                                'Passenger_ImgDocument2'    => 'image|mimes:'.config("var.MIME_IMG"),
                                'Passenger_Status'          => 'required|int',
                                'Id_TypeDocument'           => 'required|int',
                                'Id_UserCountry'            => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {

            //$Image_Current  = SELF::Image_Index($Request->input("Id_Passenger"))[0]->Passenger_Img;
            

            $oResponse      = SELF::Image_Upload(1,$Request);
            
            if ($oResponse["RespCode"] == 200) {
                $this->history->obtainOld(
                    $Request->input("Id_Passenger"),
                    self::path1_large(),
                    self::path1_thumb(),
                    self::path2_large(),
                    self::path2_thumb()
                );
                
                $Passenger_ImgDocument1     = $oResponse["Image_Name"];
                $oResponse                  = SELF::Image_Upload(2, $Request);

                if ($oResponse["RespCode"] == 200) {

                    $oParam = array(                $Request->input("Id_Passenger"),
                                         Str::title($Request->input("Passenger_Name")),
                                         Str::title($Request->input("Passenger_LastName")),
                                                    $Request->input("Passenger_Status"),
                                                    $Request->header("Token"),
                                                    1
                                    );
                    $oData = DB::select('call sp_passenger_notification(?,?,?,?,?,?)', $oParam);

                    $Passenger_ImgDocument2     = $oResponse["Image_Name"];

                    $oParam = array(                $Request->input("Id_Passenger"),
                                         Str::title($Request->input("Passenger_Name")),
                                         Str::title($Request->input("Passenger_LastName")),
                                                    $Request->input("Passenger_Email"),
                                                    $Request->input("Passenger_Phone"),
                                                    $Request->input("Passenger_Gender"),
                                                    $Request->input("Passenger_DOB"),
                                    Str::upper(trim($Request->input("Passenger_NoDocument"))),
                                                    $Request->input("Passenger_Restriction"),
                                                    $Request->input("Passenger_Extras"),
                                                    $Passenger_ImgDocument1,
                                                    $Passenger_ImgDocument2,
                                                    $Request->input("Passenger_Status"),
                                                    $Request->input("Id_TypeDocument"),
                                                    $Request->input("Id_UserCountry")
                                    );
                    $oData = DB::select('call sp_passenger_update_all(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $oParam);
                }
            }



            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->update(
                    $this->findBooking($Request->input('Id_Passenger')),
                    $this->history->oldValue,
                    [$Request->all()],
                    $Request
                );
            }else{
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);

    }
        
    public function Delete(Request $Request, $Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld (
                $Id,
                self::path1_large(),
                self::path1_thumb(),
                self::path2_large(),
                self::path2_thumb()
            );
            $oParam = array( $Id );
            $oData  = DB::select('call sp_type_receipt_delete(?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->delete(
                    $this->findBooking ($Id),
                    $this->history->oldValue,
                    $Request
                );
            }else{
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Index(Request $Request, $Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $Path_ImgDocument1_Thumb    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_THUMB");
            $Path_ImgDocument1_Large    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_LARGE");
            $Path_ImgDocument2_Thumb    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_THUMB");
            $Path_ImgDocument2_Large    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_LARGE");


            $oParam         = array(    $Id ,
                                        $Path_ImgDocument1_Thumb,
                                        $Path_ImgDocument1_Large,
                                        $Path_ImgDocument2_Thumb,
                                        $Path_ImgDocument2_Large
                                    );
            $oData          = DB::select('call sp_passenger_index(?,?,?,?,?)',$oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
        
    public function ListTour(Request $Request, $Id_Booking, $Id){
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Id($Id_Booking,$this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            
            $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);

            if ($oResponse["Response_Code"] == 200) {
                $Path_Thumb     = config("var.PATH_PUBLIC").config("var.USER_COUNTRY_THUMB");   
                $oParam = array( $Id, $Id_Booking ,$Path_Thumb);
                $oData  = DB::select('call sp_passenger_list_tour(?,?,?)',$oParam); 

                $oResponse["Response_Status"]           = 200;
                $oResponse["Response_Code"]             = 200;
                $oResponse["Response_Domain"]           = $this->oDomain;
                $oResponse["Response_Message"]          = $this->oDomain." list";
                $oResponse["Response_Data"]             = $oData;
                $oResponse["Response_Error_Message"]    = "";
                $oResponse["Response_Error_Reason"]     = "";
            }
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function List(Request $Request, $Id_Booking, $Id){
        $oResponse  = array();
        $oValParams = array( 'Type'    => 'int' );

        $oResponse = ParamsValidator::Validate_Id($Id_Booking,$this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            
            $oResponse = ParamsValidator::Validate_Action($Id,$this->oDomain);

            if ($oResponse["Response_Code"] == 200) {

                $Path_ImgDocument1_Thumb    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_THUMB");
                $Path_ImgDocument1_Large    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_LARGE");
                $Path_ImgDocument2_Thumb    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_THUMB");
                $Path_ImgDocument2_Large    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_LARGE");

                $oParam = array(    $Id,
                                    $Id_Booking,
                                    $Request->input("Type"),
                                    $Path_ImgDocument1_Thumb,
                                    $Path_ImgDocument1_Large,
                                    $Path_ImgDocument2_Thumb,
                                    $Path_ImgDocument2_Large
                                );
                $oData  = DB::select('call sp_passenger_list(?,?,?,?,?,?,?)', $oParam);

                $oResponse["Response_Status"]           = 200;
                $oResponse["Response_Code"]             = 200;
                $oResponse["Response_Domain"]           = $this->oDomain;
                $oResponse["Response_Message"]          = $this->oDomain." list";
                $oResponse["Response_Data"]             = $oData;
                $oResponse["Response_Error_Message"]    = "";
                $oResponse["Response_Error_Reason"]     = "";
            }
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Search(Request $Request){
        $oResponse  = array();
        $oValParams = array(    'Id_Tour'   => 'required|int',
                                'Date'      => 'required|string'
                            );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(    $Request->input("Id_Tour"),
                                $Request->input("Date") 
                            );
            $oData  = DB::select('call sp_passenger_search(?,?)',$oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." search";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
        
    public function Selector(Request $Request,$Id){
        if( is_numeric($Id) ){
            return SELF::Index($Request, $Id);
        }else{
            return SELF::Search($Request);
        }
    }
        
        
    public function Image_Index( $Id_Passenger){
        $Path_ImgDocument1_Thumb    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_THUMB");
        $Path_ImgDocument1_Large    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_LARGE");
        $Path_ImgDocument2_Thumb    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_THUMB");
        $Path_ImgDocument2_Large    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_LARGE");

        $oParam = array(    $Id_Passenger ,
                            $Path_ImgDocument1_Thumb,
                            $Path_ImgDocument2_Large,
                            $Path_ImgDocument2_Thumb,
                            $Path_ImgDocument2_Large
                        );
        $oData  = DB::select('call sp_passenger_index(?,?,?,?,?)',$oParam);

        return $oData;
    }

    public function Image_Upload($Type, Request $Request)
    {

        // ----------------------------------------------------------------------------------------------------------------------------------
        // INICIA VARIABLES DE FUNCCION
        // ----------------------------------------------------------------------------------------------------------------------------------
        $oResponse      = array();
        $oData          = array();

        $Image_Input    = $Type == 1 ? "Passenger_ImgDocument1" : "Passenger_ImgDocument2";
        $Image_Prefix   = $Type == 1 ? "PAX_DOC1_" : "PAX_DOC2_";
        
        $Path_Temp                  = config("var.PATH_PRIVATE").config("var.PATH_TEMP");
        $Path_ImgDocument_Thumb     = $Type == 1 ? config("var.PASSENGER_IMGDOCUMENT1_THUMB") : config("var.PASSENGER_IMGDOCUMENT2_THUMB");
        $Path_ImgDocument_Large     = $Type == 1 ? config("var.PASSENGER_IMGDOCUMENT1_LARGE") : config("var.PASSENGER_IMGDOCUMENT2_LARGE");

        $Path_ImgDocument_Thumb     = config("var.PATH_PRIVATE").$Path_ImgDocument_Thumb;
        $Path_ImgDocument_Large     = config("var.PATH_PRIVATE").$Path_ImgDocument_Large;

        // ----------------------------------------------------------------------------------------------------------------------------------
        // OBTIENE VALOR DE LA IMAGEN ACTUAL
        // ----------------------------------------------------------------------------------------------------------------------------------

        if($Request->input("Id_Passenger")){
            $oData      = SELF::Image_Index($Request->input("Id_Passenger"));
        }

        // ----------------------------------------------------------------------------------------------------------------------------------
        // SUBE ARCHIVO NUEVO O DEVUELVE URL DE ARCHIVO ACTUAL
        // ----------------------------------------------------------------------------------------------------------------------------------

        if( $Request->hasFile( $Image_Input ) ){

            $Image_Ext      = $Request->file( $Image_Input )->getClientOriginalExtension();
            $Image_Name     = $Image_Prefix.date("ymd_His")."_".str_pad($Request->input("Id_Passenger"),11,"0",STR_PAD_LEFT).".".$Image_Ext;

            if ($Request->file( $Image_Input )->move($Path_Temp, $Image_Name)) {
                //
                //  Redimensiona Imagen Thumb
                //
                $Image_Thumb = Image::make($Path_Temp.$Image_Name);
                $Image_Thumb->resize(config("var.THUMB_W"),config("var.THUMB_H"));
                $Image_Thumb->save($Path_ImgDocument_Thumb.$Image_Name);
                

                //
                //  SUBE IMAGEN LARGE
                //
                $Image_Large = Image::make($Path_Temp.$Image_Name);
                $Image_Large->save($Path_ImgDocument_Large.$Image_Name);
                

                //
                //  ELIMINA TEMPORAL
                //
                unlink($Path_Temp.$Image_Name);
                

                //
                //  ELIMINA IMAGEN ANTIGUA
                //
                SELF::Image_Remove( $Path_ImgDocument_Thumb, $Type == 1 ? $oData[0]->Passenger_ImgDocument1 : $oData[0]->Passenger_ImgDocument2 );
                SELF::Image_Remove( $Path_ImgDocument_Large, $Type == 1 ? $oData[0]->Passenger_ImgDocument1 : $oData[0]->Passenger_ImgDocument2 );


                //
                //  RESPONSE
                //
                $oResponse["RespCode"]      = 200;
                $oResponse["Image_Name"]    = $Image_Name;
                $oResponse["RespMessage"]   = null;
                $oResponse["RespData"]      = null;
                $oResponse["ErDomain"]      = null;
                $oResponse["ErReason"]      = null;
                $oResponse["ErMessage"]     = null;
            }else{
                $oResponse["RespCode"]      = 422;
                $oResponse["Image_Name"]    = "";
                $oResponse["RespMessage"]   = "Error uploading image.";
                $oResponse["RespData"]      = null;
                $oResponse["ErDomain"]      = $this->oDomain;
                $oResponse["ErReason"]      = "Error uploading image.";
                $oResponse["ErMessage"]     = "";
            }
        }else{
            $oResponse["RespCode"]      = 200;
            $oResponse["Image_Name"]    = $Type == 1 ? $oData[0]->Passenger_ImgDocument1 : $oData[0]->Passenger_ImgDocument2;
            $oResponse["RespMessage"]   = null;
            $oResponse["RespData"]      = null;
            $oResponse["ErDomain"]      = null;
            $oResponse["ErReason"]      = null;
            $oResponse["ErMessage"]     = null;
        }

        return $oResponse;
    }

    public function Image_Remove($Image_Path, $Image_Name){
        if($Image_Name != "")
        {
            if (file_exists ($Image_Path.$Image_Name))
            {
                if (unlink($Image_Path.$Image_Name)){
                    return true;
                }else{
                    return false;
                }
            }
        }
        else
        {
            return false;
        }
    }
        
        
}