<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Providers\ExcelProviderServiceReport\ExcelProviderServiceReport;
use Illuminate\Support\Facades\DB;

class c_Provider extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;


    public function __construct()
    {
        $this->oDomain = "Provider";
        $this->history = new HistoryData(HistoryTables::provider);
    }

    public function Insert(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Provider_BusinessName'     => 'required|string|max:250',
                                'Provider_TradeName'        => 'required|string|max:250',
                                'Provider_NoDocument'       => 'required|string|max:50',
                                'Provider_Address'          => 'required|string|max:250',
                                'Provider_Phone'            => 'required|string|max:30',
                                'Provider_Status'           => 'required|int',
                                'Id_TypeDocument'           => 'required|int',
                                'Id_TypeProvider'           => 'required|int',
                                'Id_Country'                => 'required|int',
                                'Id_State'                  => 'required|int',
                                'Id_City'                   => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(    Str::title( $Request->input("Provider_BusinessName")),
                                Str::title( $Request->input("Provider_TradeName")),
                                            $Request->input("Provider_NoDocument"),
                                Str::title( $Request->input("Provider_Address")),
                                            $Request->input("Provider_Phone"),
                                            $Request->input("Provider_Status"),
                                            $Request->input("Id_TypeDocument"),
                                            $Request->input("Id_TypeProvider"),
                                            $Request->input("Id_Country"),
                                            $Request->input("Id_State"),
                                            $Request->input("Id_City")
                            );
            $oData = DB::select('call sp_provider_insert(?,?,?,?,?,?,?,?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->insertBasic($Request);
                #endregion
            } else {
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
        
    }

    public function Update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Id_Provider'               => 'required|int',
                                'Provider_BusinessName'     => 'required|string|max:250',
                                'Provider_TradeName'        => 'required|string|max:250',
                                'Provider_NoDocument'       => 'required|string|max:50',
                                'Provider_Address'          => 'required|string|max:250',
                                'Provider_Phone'            => 'required|string|max:30',
                                'Provider_Status'           => 'required|int',
                                'Id_TypeDocument'           => 'required|int',
                                'Id_TypeProvider'           => 'required|int',
                                'Id_Country'                => 'required|int',
                                'Id_State'                  => 'required|int',
                                'Id_City'                   => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            
            #region HISTORY VARIABLES
            $this->history->obtainOld($Request->input('Id_Provider'));
            #endregion

            $oParam = array(                $Request->input("Id_Provider"),
                                Str::title( $Request->input("Provider_BusinessName")),
                                Str::title( $Request->input("Provider_TradeName")),                             
                                            $Request->input("Provider_NoDocument"),
                                Str::title( $Request->input("Provider_Address")),
                                            $Request->input("Provider_Phone"),
                                            $Request->input("Provider_Status"),
                                            $Request->input("Id_TypeDocument"),
                                            $Request->input("Id_TypeProvider"),
                                            $Request->input("Id_Country"),
                                            $Request->input("Id_State"),
                                            $Request->input("Id_City")
                            );
            $oData = DB::select('call sp_provider_update(?,?,?,?,?,?,?,?,?,?,?,?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->updateBasic ( $Request->input("Id_Provider"), $Request );
                #endregion
            } else {
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);

    }

    public function Delete(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            
            #region HISTORY
            $this->history->obtainOld($Id);
            #endregion

            $oParam = array( $Id );
            $oData  = DB::select('call sp_provider_delete(?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->deleteBasic ($Id, $Request);
                #endregion
            } else {
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {       
            $oParam = array( $Id );
            $oData  = DB::select('call sp_provider_index(?)',$oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function List(Request $Request, $Id)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Action($Id,$this->oDomain);

        if ($oResponse["Response_Code"] == 200) {

            $oValParams = array(  'Id_TypeProvider' => 'required|numeric',);

            $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
            
            if ($oResponse["Response_Code"] == 200) {

                $oParam =   [   $Id ,
                                $Request->input("Id_TypeProvider")
                            ];
                $oData  = DB::select('call sp_provider_list(?,?)', $oParam);
        
                $oResponse["Response_Status"]           = 200;
                $oResponse["Response_Code"]             = 200;
                $oResponse["Response_Domain"]           = $this->oDomain;
                $oResponse["Response_Message"]          = $this->oDomain." list ".$Id;
                $oResponse["Response_Data"]             = $oData;
                $oResponse["Response_Error_Message"]    = "";
                $oResponse["Response_Error_Reason"]     = "";
            }
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function listScore(Request $Request, $Id)
    {
        (new LaravelValidator())->validate($Request->all(), $this->oDomain, [
            'DateStart'             => 'required|string|date',
            'DateEnd'               => 'required|string|date'
        ]);
        $oResponse  = array();
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = [
                $Id,
                $Request->input('DateStart'),
                $Request->input('DateEnd')
            ];
            $oData  = DB::select('call sp_provider_list_score(?,?,?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list ".$Id;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function ListReview(Request $Request)
    {
        $oResponse  = array();
        //return $Request;
        $oValParams = array(    'Id'                => 'string',
                                'Date_Start'        => 'required|string',
                                'Date_End'          => 'required|string'
                            );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(    $Request->input("Id"),
                                $Request->input("Date_Start") . ' 00:00:00',
                                $Request->input("Date_End") . ' 23:59:59',
                                config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB')
                            );
            $oData  = DB::select('call sp_passenger_review_search(?,?,?,?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list ";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function ListServices(Request $Request)
    {
        $oResponse  = array();
        $oValParams = [
            'Id_Provider'       => 'required|int',
            'Group_DateStart'   => 'required|string',
            'Group_DateEnd'     => 'required|string'
        ];
        
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = [
                $Request->input("Id_Provider"),
                $Request->input("Group_DateStart"),
                $Request->input("Group_DateEnd")
            ];
            $oData = DB::select('call sp_provider_list_services(?,?,?)', $oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." search";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function ListServicesExcel(Request $Request)
    {
        $oResponse  = array();
        $oValParams = [
            'Id_Provider'       => 'required|int',
            'Group_DateStart'   => 'required|string',
            'Group_DateEnd'     => 'required|string'
        ];
        
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = [
                $Request->input("Id_Provider"),
                $Request->input("Group_DateStart"),
                $Request->input("Group_DateEnd")
            ];
            $oData = array_map (
                function ($prov) use ($Request) {
                    
                    $Path_Thumb     = config("var.PATH_PUBLIC").config("var.USER_COUNTRY_THUMB");
                    $prov->Passenger =DB::select ('CALL sp_provider_group_passenger_list(?,?,?,?)', [
                            $Request->input("Id_Provider"),
                            $Request->input("Group_DateStart"),
                            $Request->input("Group_DateEnd"),
                            $prov->Type_Report]);

                    return $prov;
                },
                DB::select('call sp_provider_list_services(?,?,?)', $oParam)
            );
            
            (new ExcelProviderServiceReport())->exportToExcel ($oData);
        } else {
            return ResponseBuilder::Response($oResponse);
        }
    }

    public function Search(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Date'          => 'required|string',
                                'Id_Tour'       => 'required|int'
                            );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {           
            $oParam = array(    $Request->input("Date"),
                                $Request->input("Id_Tour")
                            );
            $oData = DB::select('call sp_provider_search(?,?)',$oParam);

            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." search";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
        
    }

    public function Selector(Request $Request, $Id)
    {
        if( is_numeric($Id) ){
            return SELF::Index( $Request,$Id );
        }else if($Id == "search"){
            return SELF::Search( $Request,$Id );
        }else{
            return SELF::List( $Request,$Id );
        }
    }

}