<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Intervention\Image\ImageManagerStatic as Image;

class c_Registry_Detail extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct()
	{
		$this->oDomain = "Registry Detail";
		$this->historyRegistry = new HistoryData (HistoryTables::registry);
		$this->history = new HistoryData (HistoryTables::registry_detail);
	}

	public function Insert_All(Request $Request){
		$oResponse  = array();
        $oValParams = array(    'Id_Registry'		=> 'required|int',
                                'Id_Warehouse'		=> 'required|int',
								'Item'				=> 'required|string'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			$oldValue = DB::select ('call sp_registry_detail_list(?)', [ $Request->input('Id_Registry')]);

			$oItem 		= json_decode($Request->input("Item"));

			for($k = 0; $k < count($oItem); $k++){
				$oParam = array(    $oItem[$k]->Quantity,
									$oItem[$k]->Id_Item,
									$Request->input("Id_Registry"),
									$Request->input("Id_Warehouse")
								);
				$oData = DB::select('call sp_registry_detail_insert_all(?,?,?,?)',$oParam);
			}

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				$newValue = json_encode (DB::select ('call sp_registry_detail_list(?)', [ $Request->input('Id_Registry') ]));
				
				$this->historyRegistry->update (
					$Request->input("Id_Registry"),
					$oldValue,
					$newValue,
					$Request
				);
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}
	public function Insert(Request $Request){
		$oResponse  = array();
        $oValParams = array(    'RegistryDetail_Quantity'		=> 'required|string',
                                'RegistryDetail_Description'	=> 'required|string',
								'RegistryDetail_UnitPrice'		=> 'required|string',
								'Id_Registry'					=> 'required|int',
                                'Id_WarehouseBalance'			=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
            $oParam = array(    $Request->input("RegistryDetail_Quantity"),
								$Request->input("RegistryDetail_Description"),
								$Request->input("RegistryDetail_UnitPrice"),
								$Request->input("Id_Registry"),
								$Request->input("Id_WarehouseBalance")
							);
			$oData = DB::select('call sp_registry_detail_insert(?,?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				#region HISTORY EXEC
				$this->history->insertBasic ($Request);
				#endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}
	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Id_RegistryDetail'				=> 'required|int',
								'RegistryDetail_Quantity'		=> 'required|numeric',
								'RegistryDetail_Description'	=> 'required|string',
								'RegistryDetail_UnitPrice'		=> 'required|numeric'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			#region HISTORY VARIABLES
			$this->history->obtainOld($Request->input('Id_RegistryDetail'));
			#endregion

			$oParam = array(    $Request->input("Id_RegistryDetail"),
								$Request->input("RegistryDetail_Quantity"),
								$Request->input("RegistryDetail_Description"),
								$Request->input("RegistryDetail_UnitPrice")
							);
			$oData = DB::select('call sp_registry_detail_update(?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				#region HISTORY EXEC
				$this->history->updateBasic ( $Request->input("Id_RegistryDetail"), $Request );
				#endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			#region HISTORY
			$this->history->obtainOld($Id);
			#endregion

			$oParam = array( $Id );
			$oData 	= DB::select('call sp_registry_detail_delete(?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				#region HISTORY EXEC
				$this->history->deleteBasic ($Id, $Request);
				#endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_registry_detail_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id_Registry){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Id($Id_Registry, $this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id_Registry );
			$oData  = DB::select('call sp_registry_detail_list(?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	
	
}