<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;

class c_Tour_Equipment extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = "Tour Equipment";
        $this->history = new HistoryData(HistoryTables::tour_equipment);
    }

    public function Insert(Request $Request){
        $oResponse  = array();
        $oValParams = array(    'TourEquipment_Select'      => 'required|int',
                                'TourEquipment_Status'      => 'required|int',
                                'Id_TourEquipmentType'      => 'required|int',
                                'Id_Equipment'              => 'required|int',
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(    $Request->input("TourEquipment_Select"),
                                $Request->input("TourEquipment_Status"),
                                $Request->input("Id_TourEquipmentType"),
                                $Request->input("Id_Equipment")
                            );
            $oData = DB::select('call sp_tour_equipment_insert(?,?,?,?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->insertBasic ($Request);
                #endregion
            } else {
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
        
    }
    public function Update(Request $Request){
        $oResponse  = array();
        $oValParams = array(    'Id_TourEquipment'      => 'required|int',
                                'TourEquipment_Order'   => 'required|int',
                                'TourEquipment_Select'  => 'required|int',
                                'TourEquipment_Status'  => 'required|int',
                                'Id_TourEquipmentType'  => 'required|int',
                                'Id_Equipment'          => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {

            #region HISTORY VARIABLES
            $this->history->obtainOld($Request->input('Id_TourEquipment'));
            #endregion

            $oParam = array(    $Request->input("Id_TourEquipment"),
                                $Request->input("TourEquipment_Order"),
                                $Request->input("TourEquipment_Select"),
                                $Request->input("TourEquipment_Status"),
                                $Request->input("Id_TourEquipmentType"),
                                $Request->input("Id_Equipment")
                            );
            $oData = DB::select('call sp_tour_equipment_update(?,?,?,?,?,?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->updateBasic ( $Request->input("Id_TourEquipment"), $Request );
                #endregion
            } else {
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);

    }
    public function Delete(Request $Request, $Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {

            #region HISTORY
            $this->history->obtainOld($Id);
            #endregion

            $oParam = array( $Id );
            $oData  = DB::select('call sp_tour_equipment_delete(?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->deleteBasic ($Id, $Request);
                #endregion
            } else {
        
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Index(Request $Request, $Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {       
            $oParam = array( $Id );
            $oData  = DB::select('call sp_tour_equipment_index(?)',$oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function List(Request $Request, $Id_TourEquipmentType, $Id){
        $oResponse  = array();
        
        $oResponse = ParamsValidator::Validate_Id($Id_TourEquipmentType,$this->oDomain);
        
        if ($oResponse["Response_Code"] == 200) {
            $oResponse = ParamsValidator::Validate_Action($Id,$this->oDomain);

            if ($oResponse["Response_Code"] == 200) {
                $oParam = array( $Id, $Id_TourEquipmentType );
                $oData  = DB::select('call sp_tour_equipment_list(?,?)',$oParam);

                for($i = 0; $i < count($oData); $i++){
                    $oParam     = array($oData[$i]->Id_Equipment);
                    
                    $oDataEquipmentRate  = DB::select('call sp_equipment_rate_list(?)',$oParam);
        
                    $oData[$i]->Rate                =$oDataEquipmentRate;
                }

                $oResponse["Response_Status"]           = 200;
                $oResponse["Response_Code"]             = 200;
                $oResponse["Response_Domain"]           = $this->oDomain;
                $oResponse["Response_Message"]          = $this->oDomain." list ".$Id;
                $oResponse["Response_Data"]             = $oData;
                $oResponse["Response_Error_Message"]    = "";
                $oResponse["Response_Error_Reason"]     = "";
            }
        }
        return ResponseBuilder::Response($oResponse);
    }

        
}