<?php

namespace App\Http\Controllers\Passenger\ReviewSession;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\ReviewSession\Application\Create\CreateReviewSessionCommand;
use App\Modules\ReviewSession\Infraestructure\ReviewSessionValidators;
use App\Modules\Shared\Domain\Bus\Command\CommandBus;
use App\Modules\Shared\Exceptions\InvalidRequestException;
use App\Modules\Shared\Infraestructure\Requester;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

class ReviewSessionCreateController
{
    private string $domain;
    public function __construct(
        private CommandBus $commandBus
    ) {
        $this->domain = 'ReviewSession';
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), $this->domain, ReviewSessionValidators::CREATE);
        $data = [
            'Permissions' => null,
            'Provider' => null,
            'PassengerReview' => [],
            'Passenger' => []
        ];
        $document = trim($request->input('Passenger_NoDocument'));
        try {
            $response = $this->commandBus->dispatch(
                new CreateReviewSessionCommand(
                    $document
                )
            );
            $data['Permissions'] = 'PassengerReview';
            $data['PassengerReview'] = $response['Response_Data'];
        } catch (InvalidRequestException $th) {
            $data['Permissions'] = 'Provider';
            $response = Requester::requestSelect(
                'CALL sp_group_provider_search_by_document_only(?,@sts,@cod,@msg)',
                [ $document ]
            );
            $data['Provider'] = count($response['Response_Data']) ? $response['Response_Data'][0] : null;
            $providerList = $response['Response_Data'];
    
            $data['Passenger'] = array_map(
                fn($provider) => $this->getGroupProviderPassengers($provider),
                $providerList
            );
        }
        
        $oResponse = $response;
        $oResponse["Response_Data"] = $data;
        return ResponseBuilder::Response($oResponse);
    }

    private function getGroupProviderPassengers($provider)
    {
        return [
            'Group' => $provider,
            'Passenger' => []
        ];
    }
}
