<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Contracts\Auth\Factory as Auth;

use App\Http\Controllers\Passenger\c_Passenger_Session;
use App\Http\Helpers\ResponseBuilder;

class Authenticate_Passenger
{
	
	protected $auth;

	public function __construct(Auth $auth)
	{
		$this->auth = $auth;
	} 

	public function handle($Request, Closure $next, $guard = null)
	{
		if($Request->header("Token") == "" || $Request->header("Id") == ""){
			$oResponse["Response_Status"]			= 401;
			$oResponse["Response_Code"]				= 401;
			$oResponse["Response_Domain"]			= "global";
			$oResponse["Response_Message"]			= "Missing request header 'authorization' for method parameter of type String of passenger".$Request->header("Token");
			$oResponse["Response_Data"]				= NULL;
			$oResponse["Response_Error_Message"]	= "Bad Request";
			$oResponse["Response_Error_Reason"]		= "Missing request header 'authorization' for method parameter of type String".$Request->header("Id");
			
			return ResponseBuilder::Response($oResponse);
		}else{

			$oData  = c_Passenger_Session::Update($Request);

			if($oData[0]->Response_Success == 1){
				return $next($Request);
			}else{
				$oResponse["Response_Status"]			= $oData[0]->Response_Status;
				$oResponse["Response_Code"]				= $oData[0]->Response_Code;
				$oResponse["Response_Domain"]			= "global";
				$oResponse["Response_Message"]			= $oData[0]->Response_Message;
				$oResponse["Response_Data"]				= NULL;
				$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
				$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
				
				return ResponseBuilder::Response($oResponse);
			}
		}

		
	}
}
