<?php
namespace App\Http\Middleware;
use Closure;

class CorsMiddleware
{
    public function handle($request, Closure $next)
    {
        
        $headers = [
            'Access-Control-Allow-Origin'      => '*',
            'Access-Control-Allow-Methods'     => 'POST, GET, OPTIONS, PUT, DELETE',
            'Access-Control-Allow-Credentials' => 'true',
            'Access-Control-Max-Age'           => '86400',
            'Access-Control-Allow-Headers'     => 'Content-Type, Token, Url,Id, X-Requested-With,Booking_Token'
        ];

        if ($request->isMethod('OPTIONS'))
        {
            return response('', 200, $headers);
        }
        $response = $next($request);
        foreach($headers as $key => $value)
        {
            $response->header($key, $value);
        }
        return $response;
    }
}