<?php

namespace App\Modules\Admin\Application\Update;

use App\Modules\Admin\Domain\IdLead;
use App\Modules\Admin\Domain\Lead;
use App\Modules\Admin\Domain\LeadAddress;
use App\Modules\Admin\Domain\LeadContactName;
use App\Modules\Admin\Domain\LeadContactPhone;
use App\Modules\Admin\Domain\LeadEmail;
use App\Modules\Admin\Domain\LeadGender;
use App\Modules\Admin\Domain\LeadLastName;
use App\Modules\Admin\Domain\LeadName;
use App\Modules\Admin\Domain\LeadNoDocument;
use App\Modules\Admin\Domain\LeadPhone;
use App\Modules\Admin\Domain\LeadPhoneCode;
use App\Modules\Admin\Domain\LeadStatus;
use App\Modules\Admin\Domain\LeadType;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\UserCountry\Domain\IdUserCountry;

final class LeadUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private LeadUpdater $updater)
    {
    }

    public function __invoke(LeadUpdaterQuery $query): LeadUpdaterResponse
    {
        $model = new Lead(
            new LeadName($query->getName()),
            new LeadLastName($query->getLastName()),
            new LeadGender($query->getGender()),
            new LeadEmail($query->getEmail()),
            new LeadPhoneCode($query->getPhoneCode()),
            new LeadPhone($query->getPhone()),
            new LeadNoDocument($query->getNoDocument()),
            new LeadAddress($query->getAddress()),
            new LeadContactName($query->getContactName()),
            new LeadContactPhone($query->getContactPhone()),
            new LeadType($query->getType()),
            new LeadStatus($query->getStatus()),
            new IdTypeDocument($query->getIdTypeDocument()),
            new IdUserCountry($query->getIdUserCountry()),
            new IdLead($query->getId()),
        );
        return $this->updater->__invoke($model);
    }
}
