<?php

namespace App\Modules\Booking\Domain;

/** Encapsula los datos a exportar en excel del booking */
class ReportBooking
{

    private BookingCode $bookingCode;
    private BookingDate $bookingDate;
    private BookingDateStart $bookingDateStart;
    private BookingNoPax $bookingNoPax;
    private BookingStatus $bookingStatus;
    private BookingReferredFromName $bookingReferredFromName;
    private BookingRelationshipName $bookingRelationshipName;
    private AdminAbrv $adminAbrv;
    private ReportBookingTour $bookingTour;
    private ReportPassenger $passenger;
    private ReportUser $user;
    private ReportInvoice $invoice;

    /** constructor */
    public function __construct(
        BookingCode $bookingCode,
        BookingDate $bookingDate,
        BookingDateStart $bookingDateStart,
        BookingNoPax $bookingNoPax,
        BookingStatus $bookingStatus,
        BookingReferredFromName $bookingReferredFromName,
        BookingRelationshipName $bookingRelationshipName,
        AdminAbrv $adminAbrv,
        ReportBookingTour $bookingTour,
        ReportPassenger $passenger,
        ReportUser $user,
        ReportInvoice $invoice
    ) {
        $this->bookingCode = $bookingCode;
        $this->bookingDate = $bookingDate;
        $this->bookingDateStart = $bookingDateStart;
        $this->bookingNoPax = $bookingNoPax;
        $this->bookingStatus = $bookingStatus;
        $this->bookingReferredFromName = $bookingReferredFromName;
        $this->bookingRelationshipName = $bookingRelationshipName;
        $this->adminAbrv = $adminAbrv;
        $this->bookingTour = $bookingTour;
        $this->passenger = $passenger;
        $this->user = $user;
        $this->invoice = $invoice;
    }

    public function getBookingCode(): BookingCode
    {
        return $this->bookingCode;
    }
    public function getBookingDate(): BookingDate
    {
        return $this->bookingDate;
    }
    public function getBookingDateStart(): BookingDateStart
    {
        return $this->bookingDateStart;
    }
    public function getBookingNoPax(): BookingNoPax
    {
        return $this->bookingNoPax;
    }
    public function getBookingStatus(): BookingStatus
    {
        return $this->bookingStatus;
    }
    public function getBookingReferredFromName(): BookingReferredFromName
    {
        return $this->bookingReferredFromName;
    }
    public function getBookingRelationshipName(): BookingRelationshipName
    {
        return $this->bookingRelationshipName;
    }
    public function getAdminAbrv(): AdminAbrv
    {
        return $this->adminAbrv;
    }
    public function getReportBookingTour(): ReportBookingTour
    {
        return $this->bookingTour;
    }
    public function getReportPassenger(): ReportPassenger
    {
        return $this->passenger;
    }
    public function getReportUser(): ReportUser
    {
        return $this->user;
    }
    public function getReportInvoice(): ReportInvoice
    {
        return $this->invoice;
    }
}
