<?php

namespace App\Modules\Booking\Domain;

use App\Modules\Invoice\Domain\InvoiceTotalPay;
use App\Modules\Invoice\Domain\InvoiceTotal;
use App\Modules\Invoice\Domain\InvoiceCode;
use App\Modules\Invoice\Domain\InvoiceTotalPending;
use App\Modules\Invoice\Domain\InvoiceStatus;

/** Encapsula los datos a exportar en excel del booking */
class ReportInvoice {

    private InvoiceCode $invoiceCode;
    private InvoiceTotal $invoiceTotal;
    private InvoiceTotalPay $invoiceTotalPay;
    private InvoiceTotalPending $invoiceTotalPending;
    

    /** constructor */
    public function __construct (
        InvoiceCode $invoiceCode,
        InvoiceTotal $invoiceTotal,
        InvoiceTotalPay $invoiceTotalPay,
        InvoiceTotalPending $invoiceTotalPending
    ) {
        
        $this->invoiceCode = $invoiceCode;
        $this->invoiceTotal = $invoiceTotal;
        $this->invoiceTotalPay = $invoiceTotalPay;
        $this->invoiceTotalPending = $invoiceTotalPending;
    }

    public function getCode():InvoiceCode { return $this->invoiceCode; }
    public function getTotal():InvoiceTotal { return $this->invoiceTotal; }
    public function getTotalPay():InvoiceTotalPay { return $this->invoiceTotalPay; }
    public function getTotalPending():InvoiceTotalPending { return $this->invoiceTotalPending; }
}