<?php

namespace App\Modules\ExternalReview\Application;

use App\Modules\ExternalReview\Domain\ExternalReviewRepository;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

class ExternalReviewFinder
{

    private ExternalReviewRepository $repository;

    public function __construct(ExternalReviewRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke($action, DateStart $dateStart, DateEnd $dateEnd)
    {
        return $this->repository->find($action, $dateStart, $dateEnd);
    }
}
