<?php

namespace App\Modules\Group\Infraestructure;

use App\Modules\Group\Domain\GroupProviderPassengerRepository;
use App\Modules\Provider\Domain\IdProvider;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlGroupProviderPassengerRepository implements GroupProviderPassengerRepository
{
    public function find(IdProvider $idProvider, DateStart $dateStart, DateEnd $dateEnd, string $search)
    {
        return Requester::requestSelect(
            'CALL sp_group_provider_passenger_search(?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $idProvider->value(),
                $dateStart->value(),
                $dateEnd->value(),
                $search,
                config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB'),
                config('var.PATH_PUBLIC')
            ]
        );
    }
}
