<?php

namespace App\Modules\GroupPassenger\Infraestructure;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupPassenger\Domain\GroupPassengerRepository;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlGroupPassengerRepository implements GroupPassengerRepository
{

    public function findWithReview(IdGroup $idGroup, $path, $pathCountry): array
    {
        return Requester::requestSelect(
            'CALL sp_group_passenger_list_with_review(?,?,?,@sts,@cod,@msg)',
            [
                $idGroup->getValue(),
                $pathCountry,
                $path
            ]
        );
    }
}
