<?php

namespace App\Modules\HtlRoom\Domain;

class HtlRoom {

    private HtlRoomNumber $number;
    private HtlRoomStatus $status;
    private HRIdHtlCamp $idHtlCamp;
    private ?IdHtlRoom $id;


    /** constructor */
    public function __construct (
        HtlRoomNumber $number,
        HtlRoomStatus $status,
        HRIdHtlCamp $idHtlCamp,
        ?IdHtlRoom $id = NULL
    ) {
        $this->number = $number;
        $this->status = $status;
        $this->idHtlCamp = $idHtlCamp;
        $this->id = $id;
    }

    public function getNumber():HtlRoomNumber { return $this->number; }
    public function getIdHtlCamp():HRIdHtlCamp { return $this->idHtlCamp; }
    public function getStatus():HtlRoomStatus { return $this->status; }
    public function getId():IdHtlRoom { return $this->id; }

}