<?php

namespace App\Modules\Lead\Application\Delete;

use App\Modules\Lead\Domain\IdLead;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadDeleterQueryHandler implements QueryHandler
{
    public function __construct(private LeadDeleter $inserter)
    {
    }

    public function __invoke(LeadDeleterQuery $query): LeadDeleterResponse
    {
        return $this->inserter->__invoke(new IdLead($query->getId()));
    }
}
