<?php

namespace App\Modules\LeadBooking\Application\List;

use App\Modules\LeadBooking\Application\List\LeadBookingListerResponse;
use App\Modules\LeadBooking\Domain\LeadBookingRepository;

final class LeadBookingLister
{
    public function __construct(private LeadBookingRepository $repository)
    {
    }

    public function __invoke(string $action): LeadBookingListerResponse
    {
        return new LeadBookingListerResponse($this->repository->find($action));
    }
}
