<?php

namespace App\Modules\LeadBooking\Infraestructure;

use App\Modules\LeadBooking\Domain\LeadBooking;
use App\Modules\LeadBooking\Domain\LeadBookingRepository;
use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlLeadBookingRepository implements LeadBookingRepository
{

    public function find(string $action)
    {
        return Requester::requestSelect(
            'CALL sp_lead_booking_list(?,@sts,@cod,@msg)',
            [
                $action
            ]
        );
    }

    public function index(IdLeadBooking $id)
    {
        return Requester::requestSelect(
            'CALL sp_lead_booking_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(LeadBooking $value)
    {
        return Requester::requestInsert(
            'CALL sp_lead_booking_insert(?,?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getObservation()->value(),
                $value->getContact()->value(),
                $value->getStatus()->value(),
                $value->getIdAdmin()->value(),
                $value->getIdGuideLanguage()->value(),
                $value->getIdLanguage()->value(),
                $value->getIdLead()->value()
            ]
        );
    }

    public function update(LeadBooking $value)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_booking_update(?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getObservation()->value(),
                $value->getContact()->value(),
                $value->getCancellationReason()->value(),
                $value->getCancellationRemark()->value(),
                $value->getStatus()->value(),
                $value->getIdAdmin()->value(),
                $value->getIdGuideLanguage()->value(),
                $value->getIdLanguage()->value(),
                $value->getIdLead()->value()
            ]
        );
    }

    public function delete(IdLeadBooking $id)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_booking_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
