<?php

namespace App\Modules\LeadBookingService\Application\Index;

use App\Modules\LeadBookingService\Domain\IdLeadBookingService;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingServiceIndexerQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingServiceIndexer $inserter)
    {
    }

    public function __invoke(LeadBookingServiceIndexerQuery $query): LeadBookingServiceIndexerResponse
    {
        return $this->inserter->__invoke(new IdLeadBookingService($query->getId()));
    }
}
