<?php

namespace App\Modules\LeadBookingService\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class LeadBookingServiceUpdaterQuery implements Query
{
    public function __construct(
        private int $id,
        private string $quantity,
        private string $type,
        private int $status,
        private int $idLeadBookingTour,
        private int $idService
    ) {
    }

    public function id(): string
    {
        return $this->id;
    }
    public function quantity(): string
    {
        return $this->quantity;
    }
    public function type(): string
    {
        return $this->type;
    }
    public function status(): int
    {
        return $this->status;
    }
    public function idLeadBookingTour(): int
    {
        return $this->idLeadBookingTour;
    }
    public function idService(): int
    {
        return $this->idService;
    }
}
