<?php

namespace App\Modules\LeadBookingServicePassenger\Application\Delete;

use App\Modules\LeadBookingServicePassenger\Domain\IdLeadBookingServicePassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingServicePassengerDeleterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingServicePassengerDeleter $inserter)
    {
    }

    public function __invoke(LeadBookingServicePassengerDeleterQuery $query): LeadBookingServicePassengerDeleterResponse
    {
        return $this->inserter->__invoke(new IdLeadBookingServicePassenger($query->getId()));
    }
}
