<?php

namespace App\Modules\LeadBookingTourPassenger\Application\List;

use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingTourPassengerListerQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingTourPassengerLister $inserter)
    {
    }

    public function __invoke(LeadBookingTourPassengerListerQuery $query): LeadBookingTourPassengerListerResponse
    {
        return $this->inserter->__invoke(
            new IdLeadBookingTour($query->getIdLeadBookingTour()),
            $query->getAction()
        );
    }
}
