<?php

namespace App\Modules\LeadPassenger\Application\List;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadPassengerListerQueryHandler implements QueryHandler
{
    public function __construct(private LeadPassengerLister $inserter)
    {
    }

    public function __invoke(LeadPassengerListerQuery $query): LeadPassengerListerResponse
    {
        return $this->inserter->__invoke(
            new IdLeadBooking($query->getIdLeadBooking()),
            $query->getAction()
        );
    }
}
