<?php

namespace App\Modules\Machupicchu\Domain\Availability;

use App\Modules\Shared\Exceptions\BasicRequestException;
use App\Providers\ExcelReport\Utils;

class AvailabilityList
{
    public static function fromText(string $data)
    {
        $decoded = self::decodeData($data);
        $decoded = self::checkIfObject($decoded);
        $decoded = self::checkIfArray($decoded->data);
        return self::inspectElements(
            $decoded,
            Utils::compose(
                [AvailabilityList::class, 'checkIfObject'],
                [AvailabilityList::class, 'convertToAvailability']
            )
        );
    }

    private static function decodeData(string $data)
    {
        $decoded = json_decode($data);
        if (!$decoded) {
            throw new BasicRequestException(400, 400, 'The string can\'t be decoded');
        }
        return $decoded;
    }

    private static function checkIfArray($decoded)
    {
        if (!is_array($decoded)) {
            throw new BasicRequestException(400, 400, 'The decoded object must be an array');
        }
        return $decoded;
    }

    private static function inspectElements(array $data, callable $elementFunction)
    {
        return array_map($elementFunction, $data);
    }

    public static function convertToAvailability($element)
    {
        return new Availability(
            new AvailabilityCapacity($element->capacidad),
            new AvailabilityDay($element->dia),
            new AvailabilityAvailable($element->disponibilidad),
            new AvailabilityDate($element->fecha),
            new AvailabilityDatePrint($element->fechaImpresion),
            new AvailabilityHoliDay($element->feriado),
            new AvailabilityRoute($element->ruta)
        );
    }

    public static function checkIfObject($element)
    {
        if (!is_object($element)) {
            throw new BasicRequestException(400, 400, 'All elements must be objects');
        }
        return $element;
    }
}
