<?php

namespace App\Modules\ModuleNotification\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Modules\Domain\Structure\StructureModule;

class UpdateModuleNotification
{

    /** constructor */
    public function __construct(
        private IdModuleNotification $id,
        private ModuleNotificationStatus $status,
        private IdAdmin $idAdmin
    ) {
    }

    public function getId(): IdModuleNotification
    {
        return $this->id;
    }
    public function getStatus(): ModuleNotificationStatus
    {
        return $this->status;
    }
    public function getIdAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }

    public static function from(
        IdModuleNotification $id,
        ModuleNotificationStatus $status,
        IdAdmin $idAdmin
    ) {
        return new self(
            $id,
            $status,
            $idAdmin
        );
    }
}
