<?php

namespace App\Modules\PackageTour\Application\Index;

use App\Modules\PackageTour\Domain\IdPackageTour;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexPackageTourQueryHandler implements QueryHandler
{
    public function __construct(private PackageTourIndexer $inserter)
    {
    }

    public function __invoke(IndexPackageTourQuery $query): IndexPackageTourResponse
    {
        return $this->inserter->__invoke(new IdPackageTour($query->getId()));
    }
}
