<?php

namespace App\Modules\Passenger\Domain;

use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\QueryList\ListInput;

interface PassengerSearchWithReviewRepository
{
    public function search(
        DateStart $dateStart,
        DateEnd $dateEnd,
        $range,
        $idGroup,
        $action,
        ListInput $listInput,
        $paginated
    );

    public function amount(
        DateStart $dateStart,
        DateEnd $dateEnd,
        $range,
        $idGroup,
        $action
    );
}
