<?php

namespace App\Modules\Passenger\Infraestructure;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Passenger\Domain\PassengerPassengerFinderRepository;
use App\Modules\Passenger\Domain\PassengerNoDocument;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlPassengerPassengerFinderRepository implements PassengerPassengerFinderRepository {

    public function find(IdGroup $idGroup, PassengerNoDocument $passengerNoDocument) {
        return Requester::requestSelect(
            'CALL sp_passenger_passenger_search(?,?,@sts,@cod,@msg)',
            [
                $idGroup->getValue(),
                $passengerNoDocument->getValue(),
            ]
        );
    }
}
