<?php

namespace App\Modules\PaxInformation\Infraestructure;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\PaxInformation\Domain\IdPaxInformation;
use App\Modules\PaxInformation\Domain\PaxInformationDateExpire;
use App\Modules\PaxInformation\Domain\PaxInformationDescription;
use App\Modules\PaxInformation\Domain\PaxInformationRemaining;
use App\Modules\PaxInformation\Domain\PaxInformationRepository;
use App\Modules\PaxInformation\Domain\PaxInformationStatus;
use App\Modules\PaxInformation\Domain\UpdatePaxInformation;
use App\Modules\PaxInformation\Domain\UsePaxInformation;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlPaxInformationRepository implements PaxInformationRepository
{

    public function insert(
        PaxInformationDescription $description,
        PaxInformationRemaining $remaining,
        PaxInformationDateExpire $expire,
        PaxInformationStatus $status,
        IdBooking $idBooking,
        IdAdmin $idAdmin
    ):array {
        return Requester::requestInsert(
            'CALL sp_pax_information_insert(?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $description->value(),
                $remaining->value(),
                $expire->value(),
                $status->value(),
                $idBooking->value(),
                $idAdmin->value()
            ]
        );
    }

    public function find(IdBooking $idBooking, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_pax_information_list(?,?,@sts,@cod,@msg)',
            [
                $idBooking->value(),
                $action
            ]
        );
    }

    public function index(IdPaxInformation $id)
    {
        return Requester::requestSelect(
            'CALL sp_pax_information_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function update(UpdatePaxInformation $value)
    {
        return Requester::requestUpdate(
            'CALL sp_pax_information_update(?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->expire()->value(),
                $value->description()->value(),
                $value->status()->value(),
            ]
        );
    }

    public function use(UsePaxInformation $value)
    {
        return Requester::requestUpdate(
            'CALL sp_pax_information_use(?,@sts,@cod,@msg)',
            [ $value->id()->value() ]
        );
    }

    public function delete(IdPaxInformation $id)
    {
        return Requester::requestUpdate(
            'CALL sp_pax_information_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
