<?php

namespace App\Modules\PaxInformationPassenger\Application\Insert;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\PaxInformation\Domain\IdPaxInformation;
use App\Modules\PaxInformationPassenger\Application\Insert\PaxInformationPassengerInsert;
use App\Modules\PaxInformationPassenger\Application\Insert\PaxInformationPassengerInsertCommand;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerRemaining;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerStatus;

final class PaxInformationPassengerInsertCommandHandler
{
    
    private PaxInformationPassengerInsert $paxInformationPassengerInsert;
    

    public function __construct(
        PaxInformationPassengerInsert $action
    ) {
        $this->paxInformationPassengerInsert = $action;
    }

    private function action(...$args)
    {
        return $this->paxInformationPassengerInsert->__invoke(...$args);
    }

    public function __invoke(PaxInformationPassengerInsertCommand $query): array
    {
        $remaining = new PaxInformationPassengerRemaining($query->remaining());
        $status = new PaxInformationPassengerStatus($query->status());
        $idPaxInformation = new IdPaxInformation($query->idPaxInformation());
        $idPassenger = new IdPassenger($query->idPassenger());

        $response = $this->action($remaining, $status, $idPaxInformation, $idPassenger);
        return $response;
    }
}
