<?php

namespace App\Modules\Redistribution\Application;

use App\Modules\Redistribution\Domain\CreateRedistribution;
use App\Modules\Redistribution\Domain\IdRedistribution;
use App\Modules\Redistribution\Domain\RedistributionCreateRepository;
use App\Modules\RedistributionDetail\Domain\CreateRedistributionDetail;
use App\Modules\RedistributionDetail\Domain\RedistributionDetailAmount;
use App\Modules\RedistributionDetail\Domain\RedistributionDetailCreateRepository;
use Illuminate\Support\Facades\DB;

class RedistributionCreator {

    private RedistributionCreateRepository $repository;
    private RedistributionDetailCreateRepository $repositoryDetail;

    public function __construct(
        RedistributionCreateRepository $repository,
        RedistributionDetailCreateRepository $repositoryDetail
    ) {
        $this->repository = $repository;
        $this->repositoryDetail = $repositoryDetail;
    }

    public function __invoke(CreateRedistribution $model) {
        $response = $this->repository->create($model);
        $detailResponses = [];
        foreach ($model->invoices() as $inv) {
            $detailResponses[] = $this->repositoryDetail->create(
                new CreateRedistributionDetail(
                    new RedistributionDetailAmount($inv->amount()->value()),
                    $inv->idCashMovementDetail(),
                    $inv->idInvoice(),
                    $inv->idCashMovement(),
                    new IdRedistribution($response['Response_Data']['Id'])
                )
            );
        }
        return $response;
    }
}