<?php

namespace App\Modules\RedistributionDetail\Infraestructure;

use App\Modules\RedistributionDetail\Domain\CreateRedistributionDetail;
use App\Modules\RedistributionDetail\Domain\RedistributionDetailCreateRepository;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlRedistributionDetailCreateRepository implements RedistributionDetailCreateRepository {
    
    public function create(CreateRedistributionDetail $model) {
        return Requester::requestInsert(
            'CALL sp_redistribution_detail_insert(?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $model->amount()->value(),
                $model->idCashMovementDetail()->value(),
                $model->idInvoice()->value(),
                $model->idCashMovement()->value(),
                $model->idRedistribution()->value(),
            ]
        );
    }

}