<?php

namespace App\Modules\ReviewNotification\Application\Create;

use App\Modules\ReviewNotification\Application\Create\ReviewNotificationInserterResponse;
use App\Modules\ReviewNotification\Domain\InsertReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotificationRepository;

final class ReviewNotificationInserter
{
    public function __construct(private ReviewNotificationRepository $repository)
    {
    }

    public function __invoke(InsertReviewNotification $reviewNotification): ReviewNotificationInserterResponse
    {
        return new ReviewNotificationInserterResponse($this->repository->insert($reviewNotification));
    }
}
