<?php

namespace App\Modules\Shared\Domain\QueryList;

class ListInput
{

    private int $offset;
    private int $limit;
    private string $query;
    
    public function __construct(
        string $page,
        string $amount,
        string $query
    ) {
        $this->query = $query;
        $currPage = is_numeric($page) ? max(1, floor($page)) : 1;
        $currAmount = is_numeric($amount) ? max(0, floor($amount)) : 0;

        $this->offset = ($currPage - 1) * $currAmount;
        $this->limit = $currAmount;
    }
    public static function fromData($offset, $limit, $query)
    {
        $turn = new ListInput(1, 1, '');
        $turn->offset = $offset;
        $turn->limit = $limit;
        $turn->query = $query;
        return $turn;
    }

    public function getOffset():int
    {
        return $this->offset;
    }
    public function getLimit():int
    {
        return $this->limit;
    }
    public function getQuery():string
    {
        return $this->query;
    }
}
