<?php

namespace App\Modules\Shared\Infraestructure;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Exceptions\ActionRequestException;
use App\Modules\Shared\Exceptions\InvalidRequestException;
use Throwable;

class LaravelExceptionHandler {

    public function handle(Throwable $ex) {
        if ($ex instanceof InvalidRequestException) {
            
            $response = $ex->getResponse();
            return ResponseBuilder::Response($response);
        }
        if ($ex instanceof ActionRequestException) {
            $response = [];
            $response["Response_Status"]			= $ex->getResponse()->Response_Status;
            $response["Response_Code"]				= $ex->getResponse()->Response_Code;
            $response["Response_Domain"]			= '';
            $response["Response_Message"]			= $ex->getResponse()->Response_Message;
            $response["Response_Data"]				= null;
            $response["Response_Error_Message"]	    = $ex->getResponse()->Response_Message;
            $response["Response_Error_Reason"]		= $ex->getResponse()->Response_Reason;
            
            return ResponseBuilder::Response($response);
        }
        throw $ex;
    }
}