<?php

namespace App\Modules\Shared\Infraestructure\Query;

use App\Modules\Shared\Domain\Bus\Query\Query;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Symfony\Component\HttpFoundation\Exception\BadRequestException;
use App\Modules\Shared\Domain\Bus\Query\Response;

final class InMemoryQueryBus implements QueryBus
{

    public function __construct()
    {
    }

    public function ask(Query $command): ?Response
    {
        $className = get_class($command);
        $classHandler = $className . 'Handler';
        if (!class_exists($classHandler)) {
            throw new BadRequestException('Handler doesn\'t exists');
        }
        return (app()->make($classHandler))($command);
    }
}
