<?php

namespace App\Modules\Shared\Validator\Infraestructure;

use App\Http\Helpers\ParamsValidator;
use App\Modules\Shared\Exceptions\InvalidRequestException;

/** class validator with function validate */
class LaravelValidator {

    /** constructor */
    public function __construct () {
    }

    /** Function that validates the rules using Illuminate Facade Validator
     * and throws a Exception when validation fails
     */
    public function validate($data, $domain, array $rules) {
        $oResponse = ParamsValidator::Validate_Data($data, $rules, $domain);
        if ($oResponse['Response_Code'] != 200) {
            throw new InvalidRequestException($oResponse);
        }
    }

}