<?php

namespace App\Modules\UserCountry\Infraestructure;

use App\Modules\UserCountry\Domain\UserCountry;
use App\Modules\UserCountry\Domain\UserCountryRepository;
use Illuminate\Support\Facades\DB;

class MysqlUserCountryRepository implements UserCountryRepository {

    public function update(UserCountry $userCountry) {
        return DB::select(
            'call sp_user_country_update(?,?,?,?,?,?,?,?)',
            [
                $userCountry->getId()->value(),
                $userCountry->getName()->getValue(),
                $userCountry->getCode()->getValue(),
                $userCountry->getPhoneCode()->getValue(),
                $userCountry->getImg()->getValue(),
                $userCountry->getFrequent()->getValue(),
                $userCountry->getFrequentOrder()->getValue(),
                $userCountry->getStatus()->getValue(),
            ]
        );
    }

    public function insert(UserCountry $userCountry) {
        return DB::select(
            'call sp_user_country_insert(?,?,?,?,?,?,?)',
            [
                $userCountry->getName()->getValue(),
                $userCountry->getCode()->getValue(),
                $userCountry->getPhoneCode()->getValue(),
                $userCountry->getImg()->getValue(),
                $userCountry->getFrequent()->getValue(),
                $userCountry->getFrequentOrder()->getValue(),
                $userCountry->getStatus()->getValue(),
            ]
        );
    }
}