<?php

namespace App\Providers\ExcelCashMovementReport;

use App\Http\Helpers\CashMovementHelper;
use App\Http\Helpers\DateTime;

class CashMovementCells {

    private function title ($text) { return [[ 'action' => 'wrap' ], [ 'action' => 'top' ], [ 'action' => 'border' ], [ 'action' => 'print', 'text' => $text ], ['action' => 'bold']]; }
    private function column ($text) { return [[ 'action' => 'wrap' ], [ 'action' => 'top' ], [ 'action' => 'border' ], [ 'action' => 'print', 'text' => $text ]]; }

    private function createRows (array $list) {
        return array_reduce (
            $list,
            function ($carry, $cur) {
                return array_merge (
                    $carry,
                    $this->joinCM ($this->fillCM ($this->mapCM($cur), $cur), $this->mapCMD ($cur))
                );
            },
            []
        );
    }

    private function joinCM ($mapCM, $mapCMD) {
        $turn = [];
        for ($i = 0; $i < count($mapCM); $i++) {
            $turn[] = array_merge ($mapCM[$i], $mapCMD[$i]);
        }
        return $turn;
    }

    private function mapCM ($cur) {
        return [
            [
                $this->column(DateTime::dateTransform ($cur->CashMovement_DatePayment)),
                $this->column($cur->TypePayment_Name),
                $this->column(CashMovementHelper::changeReceiptNumber($cur)),
                $this->column($cur->User_Name . ' / ' . $cur->User_LastName),
                $this->column($cur->User_Type == 1 ? 'Regular' : 'Endosador' ),
                $this->column($cur->UserCountry_Name),
                $this->column($cur->User_NoDocument),
                $this->column($cur->CashMovement_Name . ' / ' . $cur->CashMovement_LastName),
                $this->column($cur->CashMovement_Email),
                $this->column($cur->CashMovement_Address),
                $this->column($cur->CashMovement_CardBrand),
                $this->column($cur->CashMovement_CardIssuer),
                $this->column(($cur->CashMovement_Type == 1 ? '-' : '' ) . $cur->CashMovement_Amount),
                $this->column($cur->CashMovement_Remark),

            ]
        ];
    }
    
    private function fillCM ($map, $cur) {
        return $this->fill ($map, count ($cur->CashMovementDetail));
    }

    private function fill ($arr, $length) {

        for ($i = count($arr); $i < $length; $i++) {
            $arr[$i] = [
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
                $this->column (''),
            ];
        }
        return $arr;
    }

    private function mapCMD ($cur) {
        if (count ($cur->CashMovementDetail) == 0) {
            return [
                [
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                    $this->column (''),
                ]
            ];
        } else {
            return array_map (
                function ($d) {
                    return [
                        $d->cant>0?   
                        [
                            ['action' => 'vmerge', 'lines' => $d->cant-1],
                            ['action' => 'print', 'text' => $d->Booking_Code],
                            ['action' => 'wrap'],
                            [ 'action' => 'border' ],
                            ['action' => 'top']
                        ] :
                        [['action' => ''], [ 'action' => 'border' ]],
                        $d->cant>0?   
                        [
                            ['action' => 'vmerge', 'lines' => $d->cant-1],
                            ['action' => 'print', 'text' => $d->invoice['Total']],
                            ['action' => 'wrap'],
                            [ 'action' => 'border' ],
                            ['action' => 'top']
                        ] :
                        [['action' => ''], [ 'action' => 'border' ]],
                        $d->cant>0?   
                        [
                            ['action' => 'vmerge', 'lines' => $d->cant-1],
                            ['action' => 'print', 'text' => $d->invoice['TotalPay']],
                            ['action' => 'wrap'],
                            [ 'action' => 'border' ],
                            ['action' => 'top']
                        ] :
                        [['action' => ''], [ 'action' => 'border' ]],
                        $d->cant>0?   
                        [
                            ['action' => 'vmerge', 'lines' => $d->cant-1],
                            ['action' => 'print', 'text' => $d->invoice['TotalPending']],
                            ['action' => 'wrap'],
                            [ 'action' => 'border' ],
                            ['action' => 'top']
                        ] :
                        [['action' => ''], [ 'action' => 'border' ]],
                        
                        $this->column($d->Passenger_Name .' '. $d->Passenger_LastName),
                        $this->column($d->ToursCanceled == 0 ? 'ACTIVO': ($d->Tours!=$d->ToursCanceled && $d->ToursCanceled > 0 ? 'PARCIALMENTE ACTIVO':($d->Tours==$d->ToursCanceled ? 'INACTIVO':""))),
                        $this->column($this->concatTour($d->Booking_Tour)),
                        $this->column($d->Passenger_NoDocument),
                        $this->column($d->UserCountry_Name),
                        $this->column($d->CashMovementDetail_Amount),
                        $this->column(DateTime::dateTransform($d->Booking_DateStart)),
                        $this->column($d->Invoice_Code),
                        $this->column($d->Invoice_TotalPending),
                        $this->column($d->Invoice_TotalPay),
                        $this->column($d->Invoice_Total),
                        $this->column($this->concatDetail($d->Invoice_Detail))
                    ];
                },
                $cur->CashMovementDetail
            );
        }
    }

    private function concatDetail (array $detail):string {
        return implode ("\n", array_map (function ($d) { return '(' . $d->InvoiceDetail_Quantity . ')' . $d->InvoiceDetail_Description; }, $detail));
    }

    private function concatTour (array $tour):string {
        return implode ("\n", array_map (function ($t) {

            $specify = '';
            switch ($t->BookingTourPassenger_Status) {
                case 0: $specify = 'NO VIAJO'; break;
                case 1: $specify = 'ANULADO'; break;
                case 2: $specify = 'ACTIVO'; break;
                case 3: $specify = 'DIO ALCANCE'; break;
                default: $specify = ''; break;
            }
            return $t->BookingTour_TourName . 
                    ($t->BookingTour_Status == 1 ? '(Anulado)':"") . ' - ' .
                    $specify .
                    '(' . DateTime::dateTransform($t->BookingTour_DateStart) . ')' ;
        }, $tour));
    }
    public function run ($oCash, $oMetadata) {
        return array_merge (
            [
                [],
                [],
                [
                    $this->title('FECHA DE PAGO'),
                    $this->title('TIPO DE PAGO'),
                    $this->title('NÚMERO DE OPERACIÓN'),
                    $this->title('NOMBRE/APELLIDO DEL CLIENTE'),
                    $this->title('TIPO DE CLIENTE'),
                    $this->title('PAIS DEL CLIENTE'),
                    $this->title('DOCUMENTO DEL CLIENTE'),
                    $this->title('NOMBRE/APELLIDO'),
                    $this->title('EMAIL'),
                    $this->title('DIRECCION'),
                    $this->title('TARJETA'),
                    $this->title('PROPIETARIO DE TARJETA'),
                    $this->title('MONTO'),
                    $this->title('OBSERVACIONES'),
                    $this->title('CODIGO DE RESERVA'),
                    $this->title('TOTAL'),
                    $this->title('MONTO PAGADO'),
                    $this->title('MONTO PENDIENTE'),
                    $this->title('PASAJERO'),
                    $this->title('ESTADO DEL PASAJERO'),
                    $this->title('TOURS'),
                    $this->title('DOCUMENTO'),
                    $this->title('PAÍS'),
                    $this->title('MONTO'),
                    $this->title('FECHA DE INICIO'),
                    $this->title('INVOICE'),
                    $this->title('PENDIENTE'),
                    $this->title('PAGADO'),
                    $this->title('TOTAL'),
                    $this->title('DETALLE'),
                ],
            ],
            $this->createRows($oCash)
        );
    }
    
}