<?php

namespace App\Providers\ExcelGroupUnitaryReport;

class EquipmentPage extends ExcelPage {

    public static function text($text) { return ['action' => 'print', 'text' => $text]; }

    public function run ($oGroup, $oData) {
        $height = 11;
        $oPassengers = $oGroup->Passenger;
        $result = [];
        for ($i = 0; $i < $height - 1; $i++) {
            $result[] = [];
        }
        $result = array_merge($result, $this->passengerFirst ($oPassengers));
        $result[] = [];
        $result[] = [];
        $result = array_merge($result, $this->passengerSecond ($oPassengers));
        $result[] = [];
        $result[] = [];
        $result = array_merge($result, $this->passengerThird ($oPassengers));
        
        return $result;
    }

    public function passengerFirst ($oPassengers) {
        $result = [];
        $result[] = array_map ([self::class, 'text'],
        [ 'NO', 'NOMBRES', '', 'APELLIDOS', 'SEXO', 'TELEFONO', 'TIPO DOC.', 'NUMERO DOC.', 'PAIS', 'RESTRICCIONES', 'EXTRAS']);
        
        foreach ($oPassengers as $key => $oPassenger) {
            $result[] = array_map ([self::class, 'text'],
            [
                ($key + 1) . '',
                $oPassenger->Passenger_Name,
                '',
                $oPassenger->Passenger_LastName,
                $oPassenger->Passenger_Gender == 1 ? 'Masculino' : 'Femenino',
                '',
                $oPassenger->TypeDocument_Name,
                $oPassenger->Passenger_NoDocument,
                $oPassenger->UserCountry_Name,
                $oPassenger->Passenger_Restriction,
                $oPassenger->Passenger_Extras,
            ]);
        }
        return $result;
    }

    public function passengerSecond ($oPassengers) {
        $result = [];
        $result[] = array_map ([self::class, 'text'],
        [ 'NO', 'NOMBRES', '', 'APELLIDOS', 'SEXO', 'TELEFONO', 'TIPO DOC.', 'NUMERO DOC.', 'PAIS', 'HOTEL', 'TREN 1', 'TREN 2']);
        
        foreach ($oPassengers as $key => $oPassenger) {
            $result[] = array_map ([self::class, 'text'],
            [
                ($key + 1) . '',
                $oPassenger->Passenger_Name,
                '',
                $oPassenger->Passenger_LastName,
                $oPassenger->Passenger_Gender == 1 ? 'Masculino' : 'Femenino',
                '',
                $oPassenger->TypeDocument_Name,
                $oPassenger->Passenger_NoDocument,
                $oPassenger->UserCountry_Name,
                $oPassenger->Booking_Address,
                $oPassenger->Passenger_Train_Remark1,
            ]);
        }
        return $result;
    }

    public function passengerThird ($oPassengers) {
        $result = [];
        $result[] = array_map ([self::class, 'text'],
        [ 'NO', 'NOMBRES', '', 'APELLIDOS', 'SEXO', 'TELEFONO', 'TIPO DOC.', 'NUMERO DOC.', 'PAIS', 'EQUIPAMIENTOS']);
        
        foreach ($oPassengers as $key => $oPassenger) {
            $result[] = array_map ([self::class, 'text'],
            [
                ($key + 1) . '',
                $oPassenger->Passenger_Name,
                '',
                $oPassenger->Passenger_LastName,
                $oPassenger->Passenger_Gender == 1 ? 'Masculino' : 'Femenino',
                '',
                $oPassenger->TypeDocument_Name,
                $oPassenger->Passenger_NoDocument,
                $oPassenger->UserCountry_Name,
                $this->mapEquipments ($oPassenger->Equipments),
            ]);
        }
        return $result;
    }

    private function mapEquipments($equipments) {
        return implode ('\n', array_map(function ($eq) { return $eq->Item_Name . ': ' . $eq->Quantity; }, $equipments));
    }

}