<?php

namespace App\Providers\ExcelRegistryReport;

class DetailCells {
    public function run ($oRegistry) {
        $isInput = $oRegistry->Registry_Type == 2;
        $oDetail = $oRegistry->Registry_Detail;
        $result = [
            [],
            [],
            [],
            [],
            [],
            [],
            [],
            [],
            [],
            [],
            [],
            [],
            [
                [[ 'action' => 'print', 'text' => 'CANTIDAD' ]],
                [[ 'action' => 'print', 'text' => $isInput ? 'PRECIO' : 'CANTIDAD DEVUELTA' ]],
                [[ 'action' => 'print', 'text' => 'DETALLE' ]],
                [[ 'action' => 'advance', 'lines' => 2 ]],
                [[ 'action' => 'print', 'text' => 'OBSERVACION' ]],
                [[ 'action' => 'advance', 'lines' => 2 ]],
            ]
        ];
        $length = count($oDetail);
        for ($i = 0; $i < $length; $i++) {
            $result[] = [
                [[ 'action' => 'print', 'text' => $oDetail[$i]->RegistryDetail_Quantity ], [ 'action' => 'left' ]],
                [[ 'action' => 'print', 'text' => $isInput ? $oDetail[$i]->RegistryDetail_UnitPrice : $oDetail[$i]->RegistryDetail_RefundQuantity ]],
                [[ 'action' => 'print', 'text' => $oDetail[$i]->RegistryDetail_Description ], [ 'action' => 'left' ]],
                [[ 'action' => 'advance', 'lines' => 2 ]],
                [[ 'action' => 'print', 'text' => $oDetail[$i]->RegistryDetail_Observation ], [ 'action' => 'left' ]],
                [[ 'action' => 'advance', 'lines' => 2 ]],
            ];
        }
        
        return $result;
    }

}