<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\Booking\Domain\BookingRepository;
use App\Modules\Booking\Infraestructure\MysqlBookingRepository;

$app->bind(BookingRepository::class, fn($app) => $app->make(MysqlBookingRepository::class));


$router->post(
    '/booking',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@Insert'
    ]
);

$router->post(
    '/booking/upgrade',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@Upgrade'
    ]
);

$router->put(
    '/booking',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@Update'
    ]
);

$router->put(
    '/booking/delete',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@Delete'
    ]
);

$router->put(
    '/booking/status',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@Status'
    ]
);

$router->get(
    '/booking/searchBooking/',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking\\BookingFindByCodeController@__invoke'
    ]
);

$router->get(
    '/booking/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@Index'
    ]
);

$router->get(
    '/booking/{Id}/sendMail',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@SendMail'
    ]
);

$router->get(
    '/booking/search/book',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@Search'
    ]
);

$router->get(
    '/booking/search/day',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@SearchDay'
    ]
);

$router->get(
    '/booking/search/passenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@Search_Passenger'
    ]
);

$router->get(
    '/booking/history/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@History_List'
    ]
);

$router->get(
    '/bookingGetReport',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@GetReport'
    ]
);

$router->put(
    '/booking/admin',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@UpdateAdmin'
    ]
);

$router->get(
    '/bookingYear',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking@Year_List'
    ]
);


$router->get(
    '/booking/report/excel',
    [
        'uses' => 'Booking\\BookingExportToExcelController@__invoke'
    ]
);

$router->put(
    '/booking/receipt',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking\\c_Receipt@__invoke'
    ]
);
