<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/externalReview',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReview\\ExternalReviewInsertController@__invoke'
    ]
);

$router->put(
    '/externalReview',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReview\\ExternalReviewUpdateController@__invoke'
    ]
);

$router->delete(
    '/externalReview/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReview\\ExternalReviewDeleteController@__invoke'
    ]
);

$router->get(
    '/externalReview/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReview\\ExternalReviewIndexController@__invoke'
    ]
);

$router->get(
    '/externalReview/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReview\\ExternalReviewListController@__invoke'
    ]
);
