<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/externalUser',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUser\\ExternalUserInsertController@__invoke'
    ]
);

$router->put(
    '/externalUser',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUser\\ExternalUserUpdateController@__invoke'
    ]
);

$router->delete(
    '/externalUser/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUser\\ExternalUserDeleteController@__invoke'
    ]
);

$router->get(
    '/externalUser/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUser\\ExternalUserIndexController@__invoke'
    ]
);

$router->get(
    '/externalUser/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalUser\\ExternalUserListController@__invoke'
    ]
);
